import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.accountingSchemaId) {
    newObjValue = {...newObjValue, 
      C_AcctSchema_ID: {
        id: body.accountingSchemaId,
        tableName: 'C_AcctSchema'
      }
    }
  }
  if(body.receivableAccountId) {
    newObjValue = {...newObjValue, 
      C_Receivable_Acct: {
        id: body.receivableAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.receivableServicesAccountId) {
    newObjValue = {...newObjValue, 
      C_Receivable_Services_Acct: {
        id: body.receivableServicesAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.liabilityAccountId) {
    newObjValue = {...newObjValue, 
      V_Liability_Acct: {
        id: body.liabilityAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.liabilityServicesAccountId) {
    newObjValue = {...newObjValue, 
      V_Liability_Services_Acct: {
        id: body.liabilityServicesAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.prepaymentAccountId) {
    newObjValue = {...newObjValue, 
      C_Prepayment_Acct: {
        id: body.prepaymentAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.vPrepaymentAccountId) {
    newObjValue = {...newObjValue, 
      V_Prepayment_Acct: {
        id: body.vPrepaymentAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.paymentDiscountExpenseAccountId) {
    newObjValue = {...newObjValue, 
      PayDiscount_Exp_Acct: {
        id: body.paymentDiscountExpenseAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.paymentDiscountRevenueAccountId) {
    newObjValue = {...newObjValue, 
      PayDiscount_Rev_Acct: {
        id: body.paymentDiscountRevenueAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.writeOffAccountId) {
    newObjValue = {...newObjValue, 
      WriteOff_Acct: {
        id: body.writeOffAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.notInvoicedReceiptsAccountId) {
    newObjValue = {...newObjValue, 
      NotInvoicedReceipts: {
        id: body.notInvoicedReceiptsAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }
  if(body.unEarnedRevenueAccountId) {
    newObjValue = {...newObjValue, 
      UnEarnedRevenue_Acct: {
        id: body.unEarnedRevenueAccountId,
        tableName: 'C_ValidCombination'
      }
    }
  }

  if(body.id) {
    const res: any = await fetchHelper(event, 'models/c_bp_group_acct/'+body.id, 'PUT', token, {
      isActive: body.isActive,
      ...newObjValue,
      tableName: 'c_bp_group_acct'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    if(err.status >= 500 || err.statusCode >= 500) {
      data = {
        status: err.status || err.statusCode,
        message: err.detail || err.details || err.message || err.statusMessage
      }
    } else {
    try {
        let authToken: any = await refreshTokenHelper(event)
        data = await handleFunc(event, authToken)
      } catch(error: any) {
        data = {
          status: error.status || error.statusCode || 500,
          message: error.detail || error.details || error.message || error.statusMessage
        }
      }
    }
  }

  return data
})